%
% Fichero para el problema de los autovalores de las frecuencias propias 
% de una cuerda vibrante. Llamamos a la funcion disparo_autovalores
% [autov, jauto, x, autof] = disparo_autovalores(xa,xb,mut,nauto)
%
% PARAMETROS FISICOS
L = 1.0; %longitud de la cuerda
T = 1.0; % tension de la cuerda
mu = 1.0/L;
mut = @(x) mu/T;
nauto = 5;

xa = 0.0;
xb = 1.0;

tic;
[autov, jauto, x, autof] = disparo_autovalores(xa,xb,mut,nauto);
toc;

figure(1);clf;
clf;plot(x,autof);

fprintf('\n Comparacion con valores teoricos\n');
autovteo = ((1:nauto)').^2*pi^2/mut(0);
omega    = sqrt(autov);
disp([autov autovteo omega]);